/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	QTPlayer
**
** DESCRIPTION:	Header file for QT player
**
**      AUTHOR:	Greg Hospelhorn
**
\******************************************************************************/

#ifndef QT_PLAYER_H
#define QT_PLAYER_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/

#include <carbon/carbon.h>
#include <QuickTime/QuickTime.h>

#include "FlashPlayerInterface.h"


/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/

class CQTPlayer : public IFlashPlayer
{
public:

	CQTPlayer(void);
	~CQTPlayer(void);

	//process
	
	const bool Load(const char *psFileName, const int iWidth, const int iHeight);
	void       Shutdown();
	
	const bool GetFrameBuffer(unsigned char **ppImageData);
	void       Play(void) const;
	void       Pause(void) const;
	void       Stop(void) const;
	void       GotoFrame(const int iFrame) const;

	//access
	const bool IsPlaying(void) const;

private:

#if !LDW_QT7

	GWorldPtr      mQtGWorld;
	int			   mFrame;
	unsigned char *mBuffer;
	
#else
	OSStatus CreatePixelBufferContext(SInt32 inPixelFormat, CGRect *inBounds, QTVisualContextRef *outVisualContext);
#endif
	OSStatus SetNumberValue(CFMutableDictionaryRef inDict, CFStringRef inKey, SInt32 inValue);

	static bool mQTStarted;

	int			m_iPreviousFrame;
		
    Movie		mMovie;
	
	
#if LDW_QT7
    QTVisualContextRef mVisualContext;
	
	CVImageBufferRef   mVideoFrameImage;
#endif	
	SInt64             mTimeIncrement;

	//class methods
	//setup
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/